#include <TFT_eSPI.h> // Graphics and font library for ST7735 driver chip
#include <SPI.h> //Used in support of TFT Display
#include <string.h>  //used for some string handling and processing.
 
TFT_eSPI tft = TFT_eSPI();  // Invoke library, pins defined in User_Setup.h
 
#define BACKGROUND TFT_GREEN
#define BALL_COLOR TFT_BLUE
 
const int DT = 40; //milliseconds
const int EXCITEMENT = 10000; //how much force to apply to ball
const uint8_t BUTTON_PIN = 16; //CHANGE YOUR WIRING TO PIN 16!!! (FROM 19)
 
uint32_t primary_timer; //main loop timer
 
//state variables:
float x_pos = 64; //x position
float y_pos = 32; //y position
float x_vel = 0; //x velocity
float y_vel = 0; //y velocity
float x_accel = 0; //x acceleration
float y_accel = 0; //y acceleration
 
//physics constants:
const float MASS = 1; //for starters
const int RADIUS = 5; //radius of ball
const float K_FRICTION = 0.15;  //friction coefficient
const float K_SPRING = 0.9;  //spring coefficient
 
//boundary constants:
const int LEFT_LIMIT = RADIUS; //left side of screen limit
const int RIGHT_LIMIT = 127-RADIUS; //right side of screen limit
const int TOP_LIMIT = RADIUS; //top of screen limit
const int BOTTOM_LIMIT = 159-RADIUS; //bottom of screen limit
 
bool pushed_last_time; //for finding change of button (using bool type...same as uint8_t)
 
//will eventually replace with your improved step function!
void step(float x_force=0, float y_force=0 ){
  //update acceleration (from f=ma)
  x_accel = x_force/MASS;
  y_accel = y_force/MASS;
  //integrate to get velocity from current acceleration
  x_vel = x_vel + 0.001*DT*x_accel; //integrate, 0.001 is conversion from milliseconds to seconds
  y_vel = y_vel + 0.001*DT*y_accel; //integrate!!
  //
  moveBall(); //you'll write this from scratch!
}
 
void moveBall(){
  //your code here
}
 
 
void setup() {
  Serial.begin(115200); //for debugging if needed.
  pinMode(BUTTON_PIN,INPUT_PULLUP);
  tft.init();
  tft.setRotation(2);
  tft.setTextSize(1);
  tft.fillScreen(BACKGROUND);
  randomSeed(analogRead(0));  //initialize random numbers
  step(random(-EXCITEMENT,EXCITEMENT),random(-EXCITEMENT,EXCITEMENT)); //apply initial force to lower right
  pushed_last_time = false;
  primary_timer = millis();
}
 
void loop() {
  //draw circle in previous location of ball in color background (redraws minimal num of pixels, therefore is quick!)
  tft.fillCircle(x_pos,y_pos,RADIUS,BACKGROUND);
  //if button pushed *just* pushed down, inject random force into system
  //else, just run out naturally
  if (!digitalRead(BUTTON_PIN)){ //if pushed
    if(!pushed_last_time){ //if not previously pushed
      pushed_last_time = true;
      step(random(-EXCITEMENT,EXCITEMENT),random(-EXCITEMENT,EXCITEMENT)); //apply initial force to lower right
    }else{
      step();
    }
  }else{ //else not pushed
    pushed_last_time = false; //mark that we were not pushed
    step(); //step as usual
  }
  tft.fillCircle(x_pos,y_pos,RADIUS,BALL_COLOR); //draw new ball location
 
  while (millis()-primary_timer < DT); //wait for primary timer to increment
  primary_timer = millis();
}
 
